/*---------------------------------------------------------------------------
 PROJET     : API CPS
 
 PLATE-FORME: TOUTES
 
 MODULE     : Fichier de declaration de CPTAB
              
 FICHIER    : common\cptab.h

 DATE       : 18/09/2000
 
 AUTEUR     : R. LAGREZE
 
 VERSION:      V 1.00
 
-----------------------------------------------------------------------------
##DEBUT HISTORIQUE##
-----------------------------------------------------------------------------
 Modifications:  (nouvelle version, date, auteur, explication)

                         
- V 1.00 - 2000/09/18 - Rene LAGREZE
       Creation


----------------------------------------------------------------------------
##FIN HISTORIQUE##                                                                             
--------------------------------------------------------------------------*/

#ifdef __cpluplus
extern "C" {
#endif

/*-----------------------------------------------------------------------------
        Definition des codes retour   
-----------------------------------------------------------------------------*/        

#define  CPTAB_ErrOk                     0x0000
#define  CPTAB_ErrTableInexistante       0x000C
#define  CPTAB_ErrManqueRessourcesSystem 0x000E
#define  CPTAB_ErrParametrage            0x000F
#define  CPTAB_ErrNok                    0x00FF
/*-----------------------------------------------------------------------------
        Definition des codes retour pour l'indicateur du mode d'execution    
-----------------------------------------------------------------------------*/

#define  CPTAB_Fic_errOk                 0x0000
#define  CPTAB_Fic_errInexistant         0x0002
#define  CPTAB_Fic_errLecture            0x0006
#define  CPTAB_Fic_errChecksum           0x0012
#define  CPTAB_Fic_errFormatTable        0x0014

/*-----------------------------------------------------------------------------
        Prototypes
-----------------------------------------------------------------------------*/        

UINT16 API_ENTRY GIPTAB_VersionTables ( PUINT16 pModeDegrade, 
                                        PSTRG   pVersionTables,
									                      PSTRG   pCheckSum,
									                      PUINT16 pNbTables);


UINT16 API_ENTRY GIPTAB_InfosSurTable ( PUINT16 pModeDegrade,
                                        PSTRG   pCODE_TABLE,
									                      PSTRG   pNOM_TABLE,
										                    PSTRG   pNOM_CHAMP,
										                    PUINT16 pNbEnregistrements,
									                      PUINT16 pTailleMaxEnregistrement);


UINT16 API_ENTRY GIPTAB_LectureLibelle ( PUINT16 pModeDegrade,
                                         PSTRG   pCODE_TABLE,
									                       PSTRG   pCODE_1,
									                       PSTRG   pCODE_2,
									                       PSTRG   pCODE_3,
										                     PUINT16 pLG_LIBELLE,
										                     PSTRG   pLIBELLE);

UINT16 API_ENTRY GIPTAB_LectureEnregistrement ( PUINT16 pModeDegrade,
                                                PSTRG   pCODE_TABLE,
									                              UINT16  RANG,
											                          PSTRG   pCODE_1,
									                              PSTRG   pCODE_2,
									                              PSTRG   pCODE_3,
										                            PUINT16 pLG_LIBELLE,
										                            PSTRG   pLIBELLE);


UINT16 API_ENTRY GIPTAB_ISO8859EnEditable     ( PSTRG   pChaineEn8859,
									                              UINT16  LgChaine,
											                          PSTRG   pChaineSurMonOS);
									            
                        

#ifdef __cpluplus
}
#endif

/*-----------------------------------------------------------------------------
        Fin de fichier CPTAB.H
-----------------------------------------------------------------------------*/        
